function sompak_init_gui()

%SOMPAK_INIT_GUI A GUI for using SOM_PAK initialization programs from Matlab.
%
%  sompak_init_gui
%
% Launches a GUI which allows the use of SOM_PAK initialization
% programs (randinit and lininit) from Matlab. Notice that to use this
% function, the SOM_PAK programs must be in your search path, or the
% variable 'SOM_PAKDIR' which is a string containing the program path,
% must be defined in the workspace. SOM_PAK programs can be found
% from: http://www.cis.hut.fi/research/som_lvq_pak.shtml
%  
% See also SOMPAK_INIT, SOMPAK_GUI, SOMPAK_SAMMON_GUI,
%          SOMPAK_TRAIN_GUI, SOM_GUI.

% Contributed to SOM Toolbox vs2, February 2nd, 2000
% Copyright (c) by Juha Parhankangas
% http://www.cis.hut.fi/projects/somtoolbox/

% Juha Parhankangas 050100

h=findobj(get(0,'Children'),'Tag','InitGUI');

if ~isempty(h)
  figure(h);
  return;
end

a = figure('Color',[0.8 0.8 0.8], ...
	'PaperType','a4letter', ...
	'Position',[483 407 172 440], ...
	'Tag','InitGUI');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
        'Callback','close gcf',...
	'FontWeight','demi', ...
	'Position',[8 20 50 20], ...
	'String','CLOSE', ...
	'Tag','Pushbutton1');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Callback','sompak_rb_control init_ok', ...
	'FontWeight','demi', ...
	'Position',[86 20 50 20], ...
	'String','OK', ...
	'Tag','Pushbutton2');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Position',[8 50 130 300], ...
	'Style','frame', ...
	'Tag','Frame1');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 54 122 40], ...
	'Style','frame', ...
	'Tag','Frame2');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'Position',[45.5 78 55 12], ...
	'String','INIT TYPE', ...
	'Style','text', ...
	'Tag','StaticText1');
b = uicontrol('Parent',a, ...
	'Callback','sompak_rb_control linear',...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Position',[14 56 17 16], ...
	'Style','radiobutton', ...
	'Tag','LINEAR', ...
	'Value',1);

udata.inittype = 'linear';

b = uicontrol('Parent',a, ...
	'Callback','sompak_rb_control rand',...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Position',[73 56 17 16], ...
	'Style','radiobutton', ...
	'Tag','RANDOM');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[33 58 30 12], ...
	'String','Linear', ...
	'Style','text', ...
	'Tag','StaticText2');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[91 58 37 12], ...
	'String','Random', ...
	'Style','text', ...
	'Tag','StaticText3');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 96 122 40], ...
	'Style','frame', ...
	'Tag','Frame3');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'Position',[36.4235 118.588 74 12], ...
	'String','NEIGHBORHOOD', ...
	'Style','text', ...
	'Tag','StaticText4');
b = uicontrol('Parent',a, ...
	'Callback','sompak_rb_control bubble',...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Position',[14 98 17 16], ...
	'Style','radiobutton', ...
	'Tag','BUBBLE', ...
	'Value',1);

udata.neigh='bubble';

b = uicontrol('Parent',a, ...
	'Callback','sompak_rb_control gaussian',...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Position',[73 98 17 16], ...
	'Style','radiobutton', ...
	'Tag','GAUSSIAN');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[33 100 32 12], ...
	'String','Bubble', ...
	'Style','text', ...
	'Tag','StaticText5');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[89.5 100 43 12], ...
	'String','Gaussian', ...
	'Style','text', ...
	'Tag','StaticText6');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 138 122 40], ...
	'Style','frame', ...
	'Tag','Frame4');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'Position',[45 162 55 12], ...
	'String','TOPOLOGY', ...
	'Style','text', ...
	'Tag','StaticText7');
b = uicontrol('Parent',a, ...
	'Callback','sompak_rb_control hexa',...
	'Units','points', ...
	'Position',[14 140 17 16], ...
	'Style','radiobutton', ...
	'Tag','HEXA', ...
	'Value',1);

udata.topol='hexa';

b = uicontrol('Parent',a, ...
	'Callback','sompak_rb_control rect',...
	'Units','points', ...
	'Position',[73 140 17 16], ...
	'Style','radiobutton', ...
	'Tag','RECT');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[33 142 30 12], ...
	'String','Hexa', ...
	'Style','text', ...
	'Tag','StaticText8');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[90 142 30 12], ...
	'String','Rect', ...
	'Style','text', ...
	'Tag','StaticText9');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 180 122 40], ...
	'Style','frame', ...
	'Tag','Frame5');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[25 202 33 12], ...
	'String','X-dim', ...
	'Style','text', ...
	'Tag','StaticText10');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[89 202 33 12], ...
	'String','Y-dim', ...
	'Style','text', ...
	'Tag','StaticText11');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control xdim',...
	'Position',[20 183 40 20], ...
	'Style','edit', ...
	'Tag','XDIM');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control ydim',...
	'Position',[85 183 40 20], ...
	'Style','edit', ...
	'Tag','YDIM');

udata.xdim=[];
udata.ydim=[];

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 222 122 40], ...
	'Style','frame', ...
	'Tag','Frame6');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'Position',[25 245 95 12], ...
	'String','OUTPUT VARIABLE', ...
	'Style','text', ...
	'Tag','StaticText12');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback','sompak_rb_control out_var',...
	'Position',[22 226 102 20], ...
	'String','''ans''', ...
	'Style','edit', ...
	'Tag','OUT_VAR');

udata.out_var='ans';

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 264 122 40], ...
	'Style','frame', ...
	'Tag','Frame7');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
        'Callback','sompak_rb_control out_file',...
	'Position',[15 267 50 20], ...
	'Style','edit', ...
	'Tag','OUT_FILE');

udata.out_file=[];

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[40 288 60 12], ...
	'String','OUTPUT FILE', ...
	'Style','text', ...
	'Tag','StaticText13');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Callback','sompak_rb_control out_ft',...
	'FontSize',9, ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Max',3, ...
	'Min',1, ...
	'Position',[70 272 62 15], ...
	'String',{'No File';'mat-file';'cod-file'}, ...
	'Style','popupmenu', ...
	'Tag','OUT_FILE_TYPE', ...
	'Value',1);

udata.out_file_type='';

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'Position',[12 306 122 40], ...
	'Style','frame', ...
	'Tag','Frame8');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Position',[57 330 30 12], ...
	'String','DATA', ...
	'Style','text', ...
	'Tag','StaticText14');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback','sompak_rb_control data',...
	'Position',[15 309 50 20], ...
	'Style','edit', ...
	'Tag','DATA');

udata.data=[];

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'Callback','sompak_rb_control input_ft',...
	'FontSize',9, ...
	'FontWeight','demi', ...
	'HorizontalAlignment','left', ...
	'Max',3, ...
	'Min',1, ...
	'Position',[70 314 62 15], ...
	'String',{'Variable';'mat-file';'dat-file'}, ...
	'Style','popupmenu', ...
	'Tag','INPUT_FILE_TYPE', ...
	'Value',1);
udata.input_file_type='';

b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'FontSize',12, ...
	'FontWeight','bold', ...
	'HorizontalAlignment','left', ...
	'Position',[57 355 30 12], ...
	'String','INIT', ...
	'Style','text', ...
	'Tag','StaticText15');

set(gcf,'UserData',udata);





